/*++

Copyright (c) 2005 AileronOS developers group
All rights reserved

File:

    cdefs.h

Abstract:

    Standard types and macros definition

Author:

    16-Aug-2005       Vlad Maslakov

--*/

#ifndef _CDEFS_H_
#define _CDEFS_H_

//
// procedure attributes definition
//

#define STDCALL   __attribute__ ((stdcall))
#define FASTCALL   __attribute__ ((fastcall))
#define CDECL     __attribute__ ((cdecl))
#define NORETURN  __attribute__ ((noreturn))

//
// boolean values definition
//

#define TRUE  (1 == 1)
#define FALSE (0 == 1)

//
// standard types definition
//

typedef char            CHAR;
typedef char*           PCHAR;
typedef char            BOOL;
typedef char            BYTE;

typedef unsigned char   UCHAR;
typedef unsigned char*  PUCHAR;

typedef short           SHORT;
typedef unsigned short  USHORT;

typedef unsigned short  WORD;
typedef unsigned short* PWORD;

typedef int             INT;
typedef unsigned int    UINT;

typedef long            LONG;
typedef unsigned long   ULONG;

typedef unsigned int    DWORD;
typedef unsigned int*   PDWORD;

typedef void*           PVOID;
typedef void*           LPVOID;

#define POINTER         *
#define PTR             *

//
// Misc
//

#define NULL            0

#endif //   _CDEFS_H_
