# 1 "dllman.c"
# 1 "<built-in>"
# 1 "<command line>"
# 1 "dllman.c"
# 20 "dllman.c"
# 1 "include\\dllman.h" 1
# 24 "include\\dllman.h"
# 1 "include\\/cdefs.h" 1
# 43 "include\\/cdefs.h"
typedef char CHAR;
typedef char* PCHAR;
typedef char BOOL;
typedef char BYTE;

typedef unsigned char UCHAR;
typedef unsigned char* PUCHAR;

typedef short SHORT;
typedef unsigned short USHORT;

typedef unsigned short WORD;
typedef unsigned short* PWORD;

typedef int INT;
typedef unsigned int UINT;

typedef long LONG;
typedef unsigned long ULONG;

typedef unsigned int DWORD;
typedef unsigned int* PDWORD;

typedef void* PVOID;
typedef void* LPVOID;
# 25 "include\\dllman.h" 2

typedef struct _DLL_LIBRARY
{
    char Name[12];
    DWORD ImageBase;
    DWORD ImpTable;
    DWORD ImpTableSize;
    DWORD ExpTable;
    DWORD ExpTableSize;
    DWORD Entry;
} DLL_LIBRARY, *PDLL_LIBRARY;

typedef struct _PE_OBJECT
{
    char Name[8];
    DWORD VirtualSize;
    DWORD SectionRVA;
    DWORD PhysicalSize;
    DWORD PhysicalOffset;
    DWORD Reserved1;
    DWORD Reserved2;
    DWORD Reserved3;
    DWORD ObjFlags;
} PE_OBJECT, *PPE_OBJECT;

typedef struct _IMPORT_ENTRY
{
    DWORD LookupRVA;
    DWORD TimeDateStamp;
    DWORD ForwardChain;
    DWORD NameRVA;
    DWORD AdTabRVA;
} IMPORT_ENTRY, *PIMPORT_ENTRY;

typedef struct _LOOKUP_TABLE
{
    WORD Hint;
    char ServiceName[32];
} LOOKUP_TABLE, *PLOOKUP_TABLE;

typedef struct _EXPORT_TABLE
{
    DWORD Flags;
    DWORD TimeDateStamp;
    WORD MajorVer;
    WORD MinorVer;
    DWORD NameRVA;
    DWORD OrdinalBase;
    DWORD FuncsCount;
    DWORD NamePtrs;
    DWORD AddrTableRVA;
    DWORD NamePtrsRVA;
    DWORD OrdTableRVA;
} EXPORT_TABLE, *PEXPORT_TABLE;

DWORD __attribute__ ((stdcall)) GetProcAddress(DLL_LIBRARY Library, EXPORT_TABLE ExpTable, char * SvcName);
DWORD __attribute__ ((stdcall)) ProcessFile(char * Name, DWORD Address);
void __attribute__ ((stdcall)) PerformLinkage();
DLL_LIBRARY __attribute__ ((stdcall)) GetExpByName(char * Name);
BOOL __attribute__ ((stdcall)) LinkLibrary(DLL_LIBRARY Library);
void __attribute__ ((stdcall)) LPrintLine(char * Text);
void __attribute__ ((stdcall)) LPrintChar(char c);
void __attribute__ ((stdcall)) LToLowerCase(char * Text);
void __attribute__ ((stdcall)) LPrintInt(DWORD Num);
# 21 "dllman.c" 2
# 1 "include\\cdefs.h" 1
# 22 "dllman.c" 2
# 1 "include\\stdfunc.h" 1
# 25 "include\\stdfunc.h"
UINT __attribute__ ((cdecl)) strlen(const CHAR * str);
BYTE __attribute__ ((cdecl)) strcpy(CHAR * dst, const CHAR * src);
void * __attribute__ ((cdecl)) memcpy(void * dst, const void * src, UINT len);
int __attribute__ ((cdecl)) strcmp(const BYTE * str1, const BYTE * str2);
# 23 "dllman.c" 2







DWORD DLLs = 0;
BYTE LastError = 0;
int CursorPos = 0;
int Attribute = 7;
# 54 "dllman.c"
DWORD __attribute__ ((stdcall)) ProcessFile(char * Name, DWORD Address)
{
    PDWORD SigAddrPtr;
    PWORD SigAddr;
    DWORD PEBase;
    DWORD ObjBase;
    WORD ObjCount;
    DLL_LIBRARY Library;
    PDLL_LIBRARY MemDest;
    int SecN;
    int Cnt;
    BYTE NamePos;
    PE_OBJECT CurObject;
    DWORD ImageSize;

    DWORD Foo;

    LPrintLine("ProcessFile Called\n");




    if (*(PWORD)Address != 0x5A4D) return 0;
    if (*(PWORD)(Address + 0x18) < 0x40) return 0;

    SigAddrPtr = Address + 0x3C;
    SigAddr = *SigAddrPtr + Address;
    if (*SigAddr != 0x4550) return 0;




    PEBase = (DWORD)SigAddr;

    LPrintLine(Name);
    LPrintLine("\n");

    memcpy(Library.Name, Name, 11);

    Library.Name[11] = '\0';
    Library.ImageBase = Address;
    Library.ImpTable = *(PDWORD)(PEBase + 0x80) + Address;
    Library.ImpTableSize = *(PDWORD)(PEBase + 0x84);
    Library.ExpTable = *(PDWORD)(PEBase + 0x78) + Address;
    Library.ExpTableSize = *(PDWORD)(PEBase + 0x7C);
    Library.Entry = *(PDWORD)(PEBase + 0x28) + Address;




    NamePos = 0;
    for (Cnt = 0; Cnt < 12; Cnt++)
        if (Library.Name[Cnt] != ' ')
        {
            if (Cnt == 8)
            {
                Library.Name[NamePos] = '.';
                NamePos++;
            }
            Library.Name[NamePos] = Library.Name[Cnt];
            NamePos++;
        }

    for (Cnt = NamePos; Cnt < 13; Cnt++)
        Library.Name[Cnt] = '\0';

    LToLowerCase(Library.Name);





    LPrintLine("Library name: ");

    LPrintLine(Library.Name);
    LPrintLine("\n");

    LPrintInt(PEBase);
    LPrintLine("\n");




    ObjCount = *(PWORD)(PEBase + 0x6);
    ObjBase = PEBase + *(PWORD)(PEBase + 0x14) + 0x18;

    for (SecN = ObjCount - 1; SecN >= 0; SecN--)
    {
        CurObject = *(PPE_OBJECT)(ObjBase + SecN * sizeof(PE_OBJECT));
        memcpy(CurObject.SectionRVA + Address, CurObject.PhysicalOffset + Address,
            CurObject.PhysicalSize);
    }




    MemDest = 0x10000 + sizeof(DLL_LIBRARY) * DLLs;
    *MemDest = Library;
    DLLs++;




    ImageSize = *(PDWORD)(PEBase + 0x50);
    LPrintInt(ImageSize);
    LPrintLine("\n");

    return ImageSize + Address;
}
# 171 "dllman.c"
void __attribute__ ((stdcall)) PerformLinkage()
{
    BYTE Done;
    DLL_LIBRARY ActiveLib;

    LPrintLine("PerformLinkage called\n");

    for (Done = 0; Done < DLLs; Done++)
    {
        ActiveLib = *(PDLL_LIBRARY)(0x10000 + sizeof(DLL_LIBRARY) * Done);
        LPrintLine("IMPS1 ");
        LPrintInt(ActiveLib.ImpTableSize);
        LPrintLine("\n");
        LinkLibrary(ActiveLib);
    }
}
# 203 "dllman.c"
BOOL __attribute__ ((stdcall)) LinkLibrary(DLL_LIBRARY Library)
{
    BYTE Entries;
    int EntryN;
    int ImpN;
    IMPORT_ENTRY Entry;
    DWORD LookupRVA;
    char SrcLibName[12];
    EXPORT_TABLE CurExp;
    DLL_LIBRARY SrcLib;
    DWORD CLookupRVA;
    char ServiceName[32];

    LPrintLine("LinkLibrary called\n");





    Entries = Library.ImpTableSize / sizeof(IMPORT_ENTRY);

    LPrintLine("Entries # ");
    LPrintInt(Entries);
    LPrintLine("\n");

    for (EntryN = 0; EntryN < Entries; EntryN++)
    {




        Entry = *(PIMPORT_ENTRY)(Library.ImpTable + sizeof(IMPORT_ENTRY) * EntryN);
        LookupRVA = *(PDWORD)(Entry.LookupRVA + Library.ImageBase);
        strcpy(SrcLibName, Library.ImageBase + Entry.NameRVA);




        SrcLib = GetExpByName(SrcLibName);
        if (LastError != 0) return (0 == 1);
        CurExp = *(PEXPORT_TABLE)(SrcLib.ExpTable);




        ImpN = 0;
        CLookupRVA = *(PDWORD)(LookupRVA + Library.ImageBase);
        while (CLookupRVA != 0)
        {
            strcpy(ServiceName, CLookupRVA + sizeof(WORD) + Library.ImageBase);

            *(PDWORD)(Library.ImageBase + Entry.AdTabRVA + sizeof(DWORD) * ImpN) =
                GetProcAddress(SrcLib, CurExp, ServiceName);

            if (LastError != 0) return (0 == 1);

            ImpN++;
            CLookupRVA = *(PDWORD)(LookupRVA + Library.ImageBase);
        }
    }

    LPrintLine("Linkage for this DLL finished");

    return (1 == 1);
}
# 284 "dllman.c"
DLL_LIBRARY __attribute__ ((stdcall)) GetExpByName(char * Name)
{
    EXPORT_TABLE CurTable;
    BOOL Complete;
    int CurEntry;
    DLL_LIBRARY CurDLL;
    char * CurName;

    Complete = (0 == 1);
    CurEntry = 0;

    while (CurEntry < DLLs && Complete == (0 == 1))
    {
        CurDLL = *(PDLL_LIBRARY)(0x10000 + CurEntry * sizeof(DLL_LIBRARY));
        CurTable = *(PEXPORT_TABLE)CurDLL.ExpTable;
        CurName = CurTable.NameRVA + CurDLL.ImageBase;
        if (strcmp(Name, CurName) == 0)
            Complete = (1 == 1);

        DLLs++;
    }

    if (Complete == (0 == 1)) LastError = 1;
    else LastError = 0;

    return CurDLL;
}
# 333 "dllman.c"
DWORD __attribute__ ((stdcall)) GetProcAddress(DLL_LIBRARY Library, EXPORT_TABLE ExpTable, char * SvcName)
{
    char * NamePtr;
    BOOL Complete;
    int CurName;
    DWORD PosInMem;

    CurName = 0;
    Complete = (0 == 1);
    NamePtr = ExpTable.NamePtrs + Library.ImageBase;
    PosInMem = 0;

    while (Complete == (0 == 1) && CurName < ExpTable.NamePtrs)
    {
        if (strcmp(SvcName, NamePtr) != 0)
        {
            CurName++;
            NamePtr = NamePtr + strlen(NamePtr) + 1;
        }
        else
        {
            PosInMem = *(PDWORD)(ExpTable.AddrTableRVA + Library.ImageBase + CurName * sizeof(DWORD)) +
                Library.ImageBase;
            Complete = (1 == 1);
        }
    }

    if (Complete == (0 == 1)) LastError = 1;
    else LastError = 0;

    return PosInMem;
}

void __attribute__ ((stdcall)) LPrintLine(char * Text)
{
    while (*Text)
    {
        LPrintChar(*Text);
        Text++;
    }
}

void __attribute__ ((stdcall)) LPrintChar(char c)
{
    char * VideoBuf = 0xB8000;
    int Cnt;

    switch (c)
    {
    case '\n':
        CursorPos += 80;
        CursorPos -= CursorPos % 80;
        break;

    default:
        *(VideoBuf + CursorPos * 2) = c;
        *(VideoBuf + CursorPos * 2 + 1) = Attribute;
        CursorPos++;
        break;
    }

    if (CursorPos > 80 * 25)
    {
        for (Cnt = 80 * 2; Cnt <= 80 * 25 * 2 + 80 * 2; Cnt++)
            *(VideoBuf + Cnt - 80 * 2) = *(VideoBuf + Cnt);

        CursorPos -= 80;
    }
}

void __attribute__ ((stdcall)) LToLowerCase(char * Text)
{
    while (*Text)
    {
        if (*Text >= 65 && *Text <= 90)
            *Text = *Text + 32;

        Text++;
    }
}

void __attribute__ ((stdcall)) LPrintInt(DWORD Num)
{
    DWORD Divider;
    DWORD Result;
    int Cnt;

    Divider = 0x10000000;
    LPrintLine("0x");

    for (Cnt = 0; Cnt < 8; Cnt++)
    {
        Result = Num / Divider;
        Num = Num % Divider;
        Divider = Divider / 0x10;

        if (Result < 10) LPrintChar(48 + Result);
        else LPrintChar(55 + Result);
    }
}
