;
;    Copyright (c) 2005 AileronOS developers group
;    All rights reserved
;
;    File:
;
;        stdfunc.asm
;
;    Abstract:
;
;        Standard functions implementation
;
;    Author:
;
;        21-Aug-2005        Vlad Maslakov
;

format coff

include "include\stdfunc.inc";

section ".text" code data

memcpy:
    .dst = 4 * 1
    .src = 4 * 2
    .len = 4 * 3
    
    push    esi
    push    edi
    
    mov     edi, [esp + 4 * 2 + .dst]
    mov     eax, edi
    mov     esi, [esp + 4 * 2 + .src]
    mov     ecx, [esp + 4 * 2 + .len]
    
    mov     edx, ecx
    shr     ecx, 2
    cld
    rep     movsd
    mov     ecx, edx
    and     ecx, 3
    rep     movsb
    
    pop     edi
    pop     esi
    retn


strcpy:
    .dst = 4 * 1
    .src = 4 * 2

    push    esi
    push    edi
    
    mov     esi, [esp + 4 * 2 + .src]
    push    esi
    call    strlen
    inc     eax
    pop     edx

    mov     edi, [esp + 4 * 2 + .dst]
    mov     ecx, eax
    mov     edx, eax
    shr     ecx, 2
    mov     eax, edi
    cld
    rep     movsd

    mov     ecx, edx
    and     ecx, 3
    rep     movsb

    pop     edi
    pop     esi
    retn


strlen:
    .str = 4 * 1

    mov     eax, [esp + .str]
    test    eax, 3
    jnz     .l_not_aligned

    .loop:
    mov     edx, [eax]
    add     eax, 4
    mov     ecx, edx
    sub     edx, 0x01010101
    and     edx, 0x80808080
    jz      .loop
    not     ecx
    and     edx, ecx
    jz      .loop
    test    dl, dl
    jnz     .l_a0
    test    dh, dh
    jnz     .l_a1
    test    edx, 0x00ff0000
    jnz     .l_a2
    jmp     .l_a3

    .l_not_aligned:
    add     eax, 4
    test    [eax-4], byte 0xff
    jz      .l_a0
    test    [eax-3], byte 0xff
    jz      .l_a1
    test    [eax-2], byte 0xff
    jz      .l_a2
    dec     eax
    and     al, 0xfc
    jmp     .loop

    .l_a0:
    dec     eax
    .l_a1:
    dec     eax
    .l_a2:
    dec     eax
    .l_a3:
    mov     ecx, [esp + .str]
    dec     eax
    sub     eax, ecx
    retn
    
strcmp:
    .str1 = 4 * 1
    .str2 = 4 * 2

    mov     ecx, [esp + .str1]
    mov     edx, [esp + .str2]
    push    ebx
    xor     eax, eax
    xor     ebx, ebx

    .loop:
    mov    al, [ecx]
    mov    bl, [edx]
    sub    eax, ebx
    jnz    .l_ret
    test   bl, bl
    jz     .l_ret
    mov    al, [ecx + 1]
    mov    bl, [edx + 1]
    sub    eax, ebx
    jnz    .l_ret
    test   bl, bl
    jz     .l_ret
    mov    al, [ecx + 2]
    mov    bl, [edx + 2]
    sub    eax, ebx
    jnz    .l_ret
    test   bl, bl
    jz     .l_ret
    mov    al, [ecx + 3]
    mov    bl, [edx + 3]
    sub    eax, ebx
    jnz    .l_ret
    add    ecx, 4
    add    edx, 4
    test   bl, bl
    jnz    .loop

    .l_ret:
    pop    ebx
    retn


