/*
 *        Copyright (c) 2005 AileronOS developers group
 *        All rights reserved
 *        See eula.txt for more information
 *
 *    File:
 *
 *        bootset.cpp
 *
 *    Abstract:
 *
 *        Boot sector installer for HDD
 *
 *    Created:
 *
 *        Vlad Maslakov
 */

#include "stdafx.h"

char file_buffer[512];
char obj_buffer[512];
char shared_buffer[2048];

int _tmain(int argc, _TCHAR* argv[])
{
    printf("Boot sector installer version 0.01\nCopyright (C) 2005 Vlad Maslakov. All rights reserved\n\n");

    if (argc<3)
    {
        printf("Not enougth arguments. Usage:\n\tbootset <disk_object_name> <boot_record_file>");
        return 0;
    }

    HANDLE DiskObject = CreateFile((LPCTSTR)argv[1], GENERIC_READ | GENERIC_WRITE,
        FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED,
        NULL);

    if (DiskObject == INVALID_HANDLE_VALUE)
    {
        printf("Could not get access to the hard disk. Ensure you have specified disk object in proper format: '\\\\.\\<disk_letter>:'");
        return 0;
    }

    HANDLE brFile = CreateFile((LPCTSTR)argv[2], GENERIC_READ | GENERIC_WRITE,
        FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, NULL, NULL);
    if (brFile==INVALID_HANDLE_VALUE)
    {
        printf("Can't open input file");
        return 0;
    }

    DWORD bytesRead;
    ReadFile(brFile, file_buffer, 512, &bytesRead, NULL);
    OVERLAPPED ovl;
    ovl.hEvent=CreateEvent(NULL,true,false,NULL);
    ovl.Offset=0;
    ovl.OffsetHigh=0;
    int result=ReadFile(DiskObject, obj_buffer, 512, &bytesRead, &ovl);
    if (result==0)
    {
        result=GetLastError();
        if (result==ERROR_IO_PENDING)
            if (WaitForSingleObject(ovl.hEvent, INFINITE) == WAIT_OBJECT_0)
                GetOverlappedResult(DiskObject, &ovl, &bytesRead, true);
            else
            {
                printf("Error while reading hard disk.");
                return 0;
            }
    }
    printf("Checking records...");
    if ((file_buffer[0]!=obj_buffer[0]) | (file_buffer[1]!=obj_buffer[1]))
    {
        printf("Error");
        return 0;
    } else printf("Done\nIntegrating data...");
    for (int i=obj_buffer[1]; i<512; i++)
        obj_buffer[i]=file_buffer[i];
    printf("Done\nAll is ready to record boot sector on hard disk. Proceed? (Yes/No/Dump)> ");
    char c;
    do
    {
        c=getch();
        if (c>90) c-=32;
    } while ((c!='Y') & (c!='N') & (c!='D'));
    printf("%c\n",c);

    if (c=='N')
    {
        printf("Operation cancelled by user");
        return 0;
    }

    if (c=='Y')
    {
        printf("Writting data to disk...");
        ovl.Offset=0;
        ovl.OffsetHigh=0;
        int result=WriteFile(DiskObject, obj_buffer, 512, &bytesRead, &ovl);
        if (result==0)
        {
            result=GetLastError();
            if (result==ERROR_IO_PENDING)
                if (WaitForSingleObject(ovl.hEvent, INFINITE) == WAIT_OBJECT_0)
                    GetOverlappedResult(DiskObject, &ovl, &bytesRead, true);
                else
                {
                    printf("Error");
                    return 0;
                }
        }
        printf("Done");
    }

    if (c=='D')
    {
        printf("Dump file name> ");
        scanf("%s",&shared_buffer);
        printf("Writting data to dump...");
        HANDLE dump = CreateFile(shared_buffer, GENERIC_READ | GENERIC_WRITE, NULL, NULL,
            OPEN_ALWAYS, NULL, NULL);
        if (dump==INVALID_HANDLE_VALUE)
        {
            printf("Error");
            return 0;
        }
        DWORD dwWrite;
        WriteFile(dump,obj_buffer,512,&dwWrite,NULL);
        printf("Done");
        CloseHandle(dump);
    }

    CloseHandle(brFile);
    CloseHandle(DiskObject);

    return 0;
}

