/*++

Copyright (c) 2005 AileronOS developers group
All rights reserved

File:

    dllman.h

Abstract:

    Header for dllman.c module

Author:

    12-Aug-2005          Vlad Maslakov

--*/


#ifndef _DLLMAN_H_
#define _DLLMAN_H_

#include "cdefs.h"

typedef struct _DLL_LIBRARY     // dll library structure descriptor
{
    char Name[12];              // library name
    DWORD ImageBase;            // base of image
    DWORD ImpTable;             // import table base
    DWORD ImpTableSize;         // import table size
    DWORD ExpTable;             // export table base
    DWORD ExpTableSize;         // export table size
    DWORD Entry;                // entry base
} DLL_LIBRARY, *PDLL_LIBRARY;

typedef struct _PE_OBJECT       // object descriptor
{
    char Name[8];               // object name
    DWORD VirtualSize;          // memory size for the object
    DWORD SectionRVA;           // RVA of the section
    DWORD PhysicalSize;         // size of the section in file
    DWORD PhysicalOffset;       // offset of the section in file
    DWORD Reserved1;
    DWORD Reserved2;
    DWORD Reserved3;
    DWORD ObjFlags;             // object flags
} PE_OBJECT, *PPE_OBJECT;

typedef struct _IMPORT_ENTRY    // import table entry descriptor
{
    DWORD LookupRVA;            // RVA of the lookup table
    DWORD TimeDateStamp;        // time/date stamp
    DWORD ForwardChain;         // forward chain...
    DWORD NameRVA;              // RVA of a name
    DWORD AdTabRVA;            // addresses table RVA
} IMPORT_ENTRY, *PIMPORT_ENTRY;

typedef struct _LOOKUP_TABLE    // lookup table descriptor
{
    WORD Hint;                  // hint
    char ServiceName[32];       // name of the service
} LOOKUP_TABLE, *PLOOKUP_TABLE;

typedef struct _EXPORT_TABLE    // export table descriptor
{
    DWORD Flags;                // reserved and equ 0
    DWORD TimeDateStamp;        // date and time of creation
    WORD MajorVer;              // major version
    WORD MinorVer;              // minor version
    DWORD NameRVA;              // RVA of the library name
    DWORD OrdinalBase;          // base of ordinals
    DWORD FuncsCount;           // count of functions
    DWORD NamePtrs;             // name pointers count
    DWORD AddrTableRVA;         // RVA of the address table
    DWORD NamePtrsRVA;          // export names table RVA
    DWORD OrdTableRVA;          // ordinals table RVA
} EXPORT_TABLE, *PEXPORT_TABLE;

DWORD STDCALL GetProcAddress(DLL_LIBRARY Library, EXPORT_TABLE ExpTable, char * SvcName);
DWORD STDCALL ProcessFile(char * Name, DWORD Address);
void STDCALL PerformLinkage();
DLL_LIBRARY STDCALL GetExpByName(char * Name);
BOOL STDCALL LinkLibrary(DLL_LIBRARY Library);
void STDCALL LPrintLine(char * Text);
void STDCALL LPrintChar(char c);
void STDCALL LToLowerCase(char * Text);
void STDCALL LPrintInt(DWORD Num);

#endif //   _DLLMAN_H_
