use16
org    0x600

sysldr_pos  equ     0x8000

start:
    jmp    _start
    
rb 40
    
include "include\gdt.inc"

_start:
    mov    ax, 0
    mov    ds, ax
    mov    ss, ax
    mov    sp, _start
    mov    es, ax
    mov    fs, ax
    mov    gs, ax

    cli

    ; disable NMI
    xor    al, al
    out    0x70, al

    ; load GDT register
    lgdt   [gdtr]

    ; enable A20 line
    in     al, 0x92
    or     al, 2
    out    0x92, al

    ; switching to PM
    mov    eax, cr0
    or     eax, 1
    mov    cr0, eax

    jmp    far 0x8:_protected_mode

use32

include "fatsp.asm"
include "hddio.asm"
include "hddproc.asm"
include "stdfunc.asm"

_protected_mode:

    mov    ax, 0x10
    mov    ds, ax
    mov    ss, ax
    mov    esp, _start
    mov    es, ax
    mov    fs, ax
    mov    gs, ax

    call   setup_fat32

    mov    dword [file_name],   'OSLD'
    mov    dword [file_name+4], 'R   '
    mov    dword [file_name+8], 'EXE '
    mov    edi, sysldr_pos
    call   read_file



