
include "include\fat32h.inc"

; shared variable(s)
file_name             rb 12
file_start_clus       dd ?
file_start_sect       dd ?

; private variable(s)
StartSector           dd ?
SectorsInCluster      db ?
RSects                dw ?
FATsOnDisk            db ?
FATSize               dd ?
RootDirCluster        dd ?
FATStartSect          dd ?
DataAreaStartSect     dd ?
RootDirStartSect      dd ?

NextEdi               dd ?

;
;    Procedure:
;
;         setup_fat32
;
;    Description:
;
;         Calculate variables to access boot disk
;
;    Input:
;
;         0x7C00 - boot sector
;
setup_fat32:
    pushad

    mov    eax, [B.HiddSec]          ; StartSector
    mov    dword [StartSector], eax

    mov    ah, [B.SecPerClus]        ; SectorsInCluster
    mov    byte [SectorsInCluster], ah

    mov    ax, [B.RsvdSecCnt]        ; RSects
    mov    word [RSects], ax

    mov    ah, [B.NumFATs]           ; FATsOnDisk
    mov    byte [FATsOnDisk], ah

    mov    eax, [B.FATSz32]          ; FATSize
    mov    dword [FATSize], eax

    mov    eax, [B.RootClus]         ; RootDirCluster
    mov    dword [RootDirCluster], eax

    mov    eax, dword [StartSector]     ; FATStartSect
    movzx  ebx, word [RSects]
    add    eax, ebx
    mov    dword [FATStartSect], eax

    mov    eax, dword [StartSector]     ; DataAreaStartSect
    movzx  ebx, word [RSects]
    add    eax, ebx
    mov    dword [DataAreaStartSect], eax
    mov    eax, dword [FATSize]
    movzx  edx, byte [FATsOnDisk]
    mul    edx
    add    dword [DataAreaStartSect], eax

    mov    eax, dword [RootDirCluster]  ; RootDirStartSect
    sub    eax, 2
    movzx  edx, byte [SectorsInCluster]
    mul    edx
    add    eax, dword [DataAreaStartSect]
    mov    dword [RootDirStartSect], eax

    popad
    ret

;
;    Procedure:
;
;        read_file
;
;    Description:
;
;        Reads file from the hard disk
;        Disk must be formatted under FAT32 file system
;
;    Input:
;
;        file_name - the file name
;        DS:EDI    - destination address
;
;    Notes:
;
;        FAT32 variables must be initialized. Before calling the
;        read_file procedure call 'setup_fat32' at once.
;
;        I offer following memory map:
;            0x1000-0x1200:    512 bytes of root directory
;            0x2000-0x2200:    512 bytes of FAT table
;
read_file:
mov word [0xB8000], "T "

    pushad
    
    push   edi

    mov    word [ChannelNumber], 1
    mov    byte [DiskNumber], 0
    mov    eax, dword [RootDirStartSect]
    mov    dword [SectorAddress], eax

    xor    ebx, ebx                      ; ebx = sectors count

read_next_rds:

    push   ebx
    mov    edi, 0x1000
    push   edi

    call   read_hdd_sector

    pop    esi
    mov    cx, 32

next_rec:
    mov    eax, dword [file_name]
    cmp    dword [esi], eax
    jne    not_this_file
    mov    eax, dword [file_name+4]
    cmp    dword [esi+4], eax
    jne    not_this_file
    mov    eax, dword [file_name+7]
    cmp    dword [esi+7], eax

    je     file_found

not_this_file:
    add    esi, 32
    loop   next_rec
    inc    dword [SectorAddress]
    pop    ebx
    inc    ebx
    movzx  eax, byte [SectorsInCluster]
    cmp    eax, ebx

    jb     read_next_rds
    jmp    err_not_found

file_found:

    mov    dword [0xB8000], 'F D '

    xor    eax, eax
    mov    ax, word [esi+0x14]
    shl    eax, 16
    mov    ax, word [esi+0x1A]
    add    sp, 4                         ; remove ebx value from stack
    pop    edi

reading_loop:

    call   read_cluster

    cmp    eax, 0x0FFFFFF8
    jl    reading_loop
    jmp    finished

err_not_found:
    mov    dword [0xB8000], 'N F '
    hlt
    jmp    $

finished:
    mov    [NextEdi], edi
    popad
    mov    edi, [NextEdi]
    ret

;
;    Procedure:
;
;        read_cluster
;
;    Description:
;
;        Reads cluster into memory
;
;    Input:
;
;        EAX    - cluster number
;        DS:EDI - destination address
;
;    Output:
;
;        EDI    - previous EDI + ClusterSize (in bytes)
;        EAX    - next cluster number (or EOF sign)
;
read_cluster:
    push   eax
    sub    eax, 2
    movzx  edx, byte [SectorsInCluster]
    mul    edx
    add    eax, dword [DataAreaStartSect]
    movzx  cx, byte [SectorsInCluster]
    push   edi

    call   read_sectors
    
    pop    edi
    pop    eax
    push   edi

    call   get_cluster

    pop    edi
    push   eax
    movzx  ecx, byte [SectorsInCluster]
    mov    eax, 512                                ; one sector = 512 bytes
    mul    ecx
    add    edi, eax
    pop    eax
    ret

;
;    Procedure:
;
;        get_cluster
;
;    Description:
;
;        Looks for cluster of the file
;
;    Input:
;
;        EAX - current cluster number
;
;    Output:
;
;        EAX - next cluster number
;

get_cluster:
     xor    edx, edx
     mov    ebx, 128                  ; 128 FAT fragments per sector
     div    ebx
     push   edx
     add    eax, dword [FATStartSect]
     
     mov    word [ChannelNumber], 1
     mov    byte [DiskNumber], 0
     mov    dword [SectorAddress], eax
     mov    edi, 0x2000
     call   read_hdd_sector
     
     pop    eax
     mov    ebx, 4
     mul    ebx
     
     add    eax, 0x2000
     mov    eax, dword [eax]
     ret


;
;    Procedure:
;
;        read_sectors
;
;    Description:
;
;        Reads sectors from hard disk
;
;    Input:
;
;        EAX    - first sector number
;        DS:EDI - destination buffer
;        CX     - sectors count
;
read_sectors:
    pushad

    mov    word [ChannelNumber], 1
    mov    byte [DiskNumber], 0
    
repl:
    push   edi
    push   cx
    push   eax
    mov    dword [SectorAddress], eax
    call   read_hdd_sector
    
    pop    eax
    inc    eax
    pop    cx
    pop    edi
    add    edi, 512
    loop   repl

    popad
    retn

