;
;    Copyright (c) 2005 AileronOS developers group
;    All rights reserved
;
;    File:
;
;        sysldr.asm
;
;    Abstract:
;
;        Aileron operating system loader main file
;
;    Created:
;
;        29-Mar-2005              Vlad Maslakov
;
;    Revisions:
;
;        11-Aug-2005              Vlad Maslakov
;            a) hard disk reading code
;            b) some user interface features implemented
;


format coff

section ".main" code data

use16
org    0x600

include "include\macros.inc"        ; macro definitions file
include "include\hddio.inc"         ; Disk I/O procedures
include "include\hddproc.inc"       ; HDD procedures
include "include\gdt.inc"           ; global descriptors table
include "include\fatsp.inc"         ; FAT32 procedures
include "include\general.inc"       ; variable(s)
include "include\bridge.inc"

start:
    jmp    _start

align 4
rb 40

_stack:                              ; the stack label

    ; this variables defines some boot parameters
    ; at this time this parameters is not used but it is reserved on
    ; future
    bootdisk       db 0
    networkboot    db 0
    safemode       db 0
                   rb 13           ; I want to reserve totally 16 bytes
                                   ; for boot parameters
                                   ; the parameters must be readed in REAL 16-bit mode.

_start:
    mov    ax, 0
    mov    ds, ax
    mov    ss, ax
    mov    sp, _stack
    mov    es, ax
    mov    fs, ax
    mov    gs, ax

    ; set VESA 800x600x16 mode. Note: VESA video buffer begins
    ; at 0xA0000

;    mov    bx, 0x100
;    mov    ax, 0x4F02
;    int    0x10

    ; VESA setup complete

    cli

    ; disable NMI
    xor    al, al
    out    0x70, al

    ; load GDT register
    lgdt   [gdtr]

    ; enable A20 line
    in     al, 0x92
    or     al, 2
    out    0x92, al

    ; calculating parameters for jump instruction
    mov    edi, _protected_mode
    xor    eax, eax
    mov    ax, cs
    sub    edi, eax
    shl    eax, 4
    add    edi, eax

    ; switching to PM
    mov    eax, cr0
    or     eax, 1
    mov    cr0, eax

    jmp    far 0x8:_protected_mode

use32

_protected_mode:

    mov    ax, 0x10
    mov    ds, ax
    mov    ss, ax
    mov    esp, _stack
    mov    es, ax
    mov    fs, ax
    mov    gs, ax
    
    call   setup_fat32

    mov    dword [file_name],   'LIB1'
    mov    dword [file_name+4], '    '
    mov    dword [file_name+8], 'DLL '
    mov    edi, 0x100000
    push   edi
    call   read_file
    push   file_name
    call   ProcessFile

    mov    dword [file_name],   'LIB2'
    mov    dword [file_name+4], '    '
    mov    dword [file_name+8], 'DLL '
    mov    edi, 0x110000
    push   edi
    call   read_file
    push   file_name
    call   ProcessFile

    call   PerformLinkage
    
hlt
jmp $
    
 
sysldr_finish:
    hlt
    jmp    $

fatal_zero:
;    hlt
    jmp    $

