;
;        Copyright (c) 2005 AileronOS developers group
;        All rights reserved
;        See eula.txt for more information
;
;    File:
;
;        sysldr\hddproc.asm
;
;    Abstract:
;
;        Hard disk input
;
;    Created:
;
;        Vlad Maslakov, 2005
;

format coff

include "include\hddio.inc"
include "include\hddproc.inc"

section ".text" code data

use32

SectorAddress	dd	?

;
;    Procedure:
;
;        read_hdd_sector
;
;    Abstract:
;
;        Read HDD sector
;
;    Input:
;
;        ChannelNumber - number of channel (1 or 2)
;        DiskNumber    - number of disk (0 or 1)
;        SectorAddress - number of the sector
;        DS:EDI        - destination address
;
;    Output:
;        DS:EDI        - 512 bytes
;
read_hdd_sector:
	pushad

	mov     byte [ATAAddressMode], 1
	mov     byte [ATAFeatures], 0
	mov     byte [ATASectorsCount], 1
	mov     eax, [SectorAddress]
	mov     dword [ATASectorNumber], eax
	mov     byte [ATACommand], 0x20
	call    send_command_to_hdd

	mov     dx, [ATABasePortAddr]
	add     dx, 7

wait_complete:
	in      al, dx
	test    al, 0x80
	jnz     wait_complete
	test    al, 0x8
	jz      wait_complete

	; receive sector
	push    es
	mov     ax, ds
	mov     es, ax
	cld
	mov     dx, [ATABasePortAddr]
	mov     cx, 256
	rep     insw
 	pop     es

	popad
	ret
