
StandardATABases    dw 0x1F0, 0x170
ChannelNumber       dw ?
DiskNumber          db ?
ATABasePortAddr     dw ?

ATAFeatures         db ?
ATASectorsCount     db ?
ATASectorNumber     db ?
ATACylinder         dw ?
ATAHead             db ?
ATAAddressMode      db ?
ATACommand          db ?

DevErrorCode        db 0


;
; Routine: send_command_to_hdd
;
; Input:
;    ChannelNumber   - number of channel (1 or 2)
;    DiskNumber      - number of disk (0 or 1)
;    ATAFeatures     - "features"
;    ATASectorCount  - sector count
;    ATASectorNumber - number of the first sector
;    ATACylinder     - number of the first cylinder
;    ATAHead         - number of first head
;    ATAAddressMode  - address mode (0-CHS, 1-LBA)
;    ATACommand      - number of command
;
; Output:
;    ATABasePortAddr - HDD base address
;
send_command_to_hdd:
    pushad

    ; setting base address of the hard disk
    xor    ebx, ebx
    mov    bx, [ChannelNumber]
    dec    bx
    shl    bx, 1
    lea    esi, [StandardATABases]
    add    esi, ebx
    mov    ax, [es:esi]
    mov    [ATABasePortAddr], ax

    ; wait while HDD will be ready to receive command
    ; choose disk we need
    mov    dx, [ATABasePortAddr]
    add    dx, 6
    mov    al, [DiskNumber]
    shl    al, 4
    or     al, 10100000b
    out    dx, al
    inc    dx

    ; and wait for disk ready
wait_hdd_ready:
    in     al, dx
    test   al, 0x80
    jnz    wait_hdd_ready
    test   al, 0x8
    jnz    wait_hdd_ready

    ; load command to controller's registers
    mov    dx, [ATABasePortAddr]
    inc    dx            ; features register
    mov    al, [ATAFeatures]
    out    dx, al
    inc    dx            ; sectors count
    mov    al, [ATASectorsCount]
    out    dx, al
    inc    dx            ; 1st sector number
    mov    al, [ATASectorNumber]
    out    dx, al
    inc    dx            ; cylinder's number (lower byte)
    mov    ax, [ATACylinder]
    out    dx, al
    inc    dx            ; cylinder's number (upper byte)
    mov    al, ah
    out    dx, al
    inc    dx            ; head and disk number
    mov    al, [DiskNumber]
    shl    al, 4
    or     al, [ATAHead]
    or     al, 10100000b
    mov    ah, [ATAAddressMode]
    shl    ah, 6
    or     al, ah
    out    dx, al

    ; sending command
    mov    al, [ATACommand]
    inc    dx
    out    dx, al

    popad
    ret


;
; Routine: device_reset
;
; Input:
;    ChannelNumber - number of channel (1 or 2)
;    DiskNumber    - number of disk (0 or 1)
;    
device_reset:
    pusha
    push    es

    ; set base address
    mov    bx, [ChannelNumber]
    dec    bx
    shl    bx, 1
    lea    si, [StandardATABases]
    add    si, bx
    mov    dx, [si]

    add    dx, 6
    mov    al, [DiskNumber]
    shl    al, 4
    or    al, 10100000b

    ; send the "reset" command
    mov    al, 0x8
    inc    dx
    out    dx, al

wait_hdd_ready2:

    in    al, dx
    test    al, 0x80
    jnz    wait_hdd_ready2
    pop    es

    popa
    ret
