#################################################
# FILE: Makefile
# 
# Author: Nathan Boeger and Mana Tominaga
#
# NOTES:
# This file is included in every chapter's Makefile
# and contains the main directives.
#
###############################################

DIRS =  04 05 06 07 08


# Make the OBJ's from our defined C  files
.ifdef SRC
OBJS     += ${SRC:.c=.o}
PROGS		+= ${SRC:.c=}
.endif

# define the  Compiler. The compiler flags will be appended 
# if defined, else they are just assigned the values below
CC               =       gcc     
CFLAGS          +=       -O
LINK            +=       -lc     


# Add a debug flag.. 
.ifdef DEBUG
CFLAGS      += -g
.endif

# Targets
all: ${OBJS} 
.for _p_ in ${PROGS}
	${CC} ${CFLAGS} -o ${_p_} ${_p_}.o	
.endfor

clean:
	rm -f $(PROGS) *.o *.core


# SUFFIX RULES
.SUFFIXES: .c .o

.c.o:
	$(CC) $(CFLAGS) -c ${.IMPSRC} 
