/*
 * proc_ids.c  
 * to compile:  gcc -O -pipe  proc_ids.c -o proc_ids 
 */
#include <stdio.h>
#include <unistd.h>

#define MAXBUF (128)

int main(int argc, char **argv)
{
	int c;
	char buf[MAXBUF];
	pid_t me,momie,family;

	/*
	 * Get our process info, 
	 * Our pid, Parents, then group
	 */
	me = getpid();
	momie = getppid();
	family = getpgrp();

	/*
	 * Read from STDIN and write out to STDOUT for flexibility; 
	 * we can sit in between two pipes or as the final
	 * end of a pipe.
	 */
	while( (c = read(STDIN_FILENO, buf, MAXBUF) ) )
	{
		write(STDOUT_FILENO, buf, c );
	}

	printf("\n\nPID [%d]\nPARENT [%d]\nGROUP [%d]\n", me, momie, family);

	return(0);
}


