#!/bin/sh

. /etc/rc.d/rc.conf

# Tell the viewers what's going to happen.
echo -e '\033[1;31;40mGoing multiuser\033[0m'
echo '' >>${log} 2>&1
echo 'Going multiuser:' >${log} 2>&1

# Screen blanks after 10 minutes idle time.
/bin/setterm -blank 10

# Set the hostname.
echo -n "setting hostname: "
if [ "${hostname}" != "" ]; then
    hostname ${hostname%%.*} >>${log} 2>&1
    domainname ${hostname#*.} >>${log} 2>&1
else
    hostname localhost >>${log} 2>&1
    domainname localdomain >>${log} 2>&1
fi
    echo "`hostname`.`domainname`"
				
# Initialize PCMCIA devices:
if [ "${pcmcia}" = "YES" ]; then
    if [ -x /etc/rc.d/rc.pcmcia ] ; then
	echo "Initiaze PCMCIA devices... "
	/etc/rc.d/rc.pcmcia start >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
fi

# Initialize the networking hardware:
if [ -x /etc/rc.d/rc.inet1 ]; then
    /etc/rc.d/rc.inet1
fi
# Initialize the hotplugging subsystem for PCI, Cardbus, and USB devices:
if [ "${hotplug}" = "YES" ]; then
    if [ -x /etc/rc.d/rc.hotplug -a -r /proc/modules ]; then
	if ! grep nohotplug /proc/cmdline > /dev/null 2>&1 ; then
	    echo "Initialize the hotplugging... "
	    . /etc/rc.d/rc.hotplug start >>${log} 2>&1 &&
	    echo "ok" || echo "error"
	fi
    fi
fi

# Load system settings
if [ ${sysctl} = "YES" ]; then
    if [ -r /etc/sysctl.conf ];then
	echo -n "Loading system settings... "
	/sbin/sysctl -p >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
fi

# Start networking daemons:
if [ -x /etc/rc.d/rc.inet2 ]; then
    /etc/rc.d/rc.inet2
fi

echo -e '\033[1;31;40mStarting system daemons:\033[0m'
echo '' >>${log} 2>&1
echo 'Starting system daemons:' >>${log} 2>&1

# Remove stale locks and junk files (must be done after mount -a!)
/bin/rm -rf /var/lock/* /var/spool/uucp/LCK..* /tmp/.X*lock /tmp/core /core >>${log} 2>&1

# Ensure basic filesystem permissions sanity.
chmod 755 / >>${log} 2>&1
chmod 1777 /tmp /var/tmp >>${log} 2>&1

# Start the print spooling system.  This will usually be LPD or CUPS.
if [ "${printd}" = "YES" ]; then
    if [ -x /etc/rc.d/rc.cups ]; then
	echo -n "Start the print spooling system... "
	/etc/rc.d/rc.cups start >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
fi

# Start smartd, which monitors the status of S.M.A.R.T.:
if [ "${smartd}" = "YES" ]; then
    if [ -x /usr/sbin/smartd ]; then
	echo -n "Start smartd... "
	/usr/sbin/smartd >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
fi	

# Monitor the UPS with genpowerd.
# To use this, uncomment it and edit in your serial device and UPS type.  For
# more information, see "man genpowerd" or the extensive documentation in the
# /usr/doc/genpower-1.0.1 directory.  You can see a list of supported UPS
# devices by running genpowerd from the command line.
# You'll also need to configure a similar block in /etc/rc.d/rc.6 if you want
# support for stopping the UPS's inverter after the machine halts.
if [ "${genpowerd}" = "YES" ]; then
    if [ -x /sbin/genpowerd  ]; then
	echo -n "Starting genpowerd daemon... "
	/sbin/genpowerd /dev/ttyS4 tripp-nt >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
fi

# Turn on process accounting.  To enable process accounting, make sure the
# option for BSD process accounting is enabled in your kernel, and then
# create the file /var/log/pacct (touch /var/log/pacct).  By default, process
# accounting is not enabled (since /var/log/pacct does not exist).  This is
# because the log file can get VERY large.
if [ "${accton}" = "YES" ]; then
    if [ -x /sbin/accton -a -r /var/log/pacct -a ]; then
    	echo -n "Process accounting turning on... "
	/sbin/accton /var/log/pacct >>${log} 2>&1 &&
	chmod 640 /var/log/pacct 2>>${log} &&
	echo "ok" || echo "error"
    fi
fi

# Start crond (Dillon's crond):
# If you want cron to actually log activity to /var/log/cron, then change
# -l10 to -l8 to increase the logging level.
if [ "${crond}" = "YES" ]; then
    if [ -x /usr/sbin/crond ]; then
	echo -n "Starting cron daemon... "
	/usr/sbin/crond -l8 >>/var/log/cron 2>>${log} &&
	echo "ok" || echo "error"
    fi
fi

# Start at daemon
if [ "${atd}" = "YES" ]; then
    if [ -x /usr/sbin/crond ]; then
	echo -n "Starting at daemon... "
	/usr/sbin/atd >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
fi

# Check quotas and then turn quota system on:
if [ "${quotas}" = "YES" ]; then
    if [ -x /sbin/quotacheck ]; then
	echo -n "Checking filesystem quotas... "
	/sbin/quotacheck -avugM >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
    if [ -x /sbin/quotaon ]; then
	echo -n "Activating filesystem quotas... "
	/sbin/quotaon -avug >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
fi

# Start the APM daemon if APM is enabled in the kernel:
if [ "${apmd}" = "YES" ]; then
    if [ -x /usr/sbin/apmd ]; then
	if cat /proc/apm > /dev/null 2>&1 ; then
	    echo -n "Starting APM daemon... "
	    /usr/sbin/apmd >>${log} 2>&1 &&
	    echo "ok" || echo "error"
	fi
    fi
fi

# Start the ACPI (Advanced Configuration and Power Interface) daemon:
if [ "${acpid}" = "YES" ]; then
    if [ -x /etc/rc.d/rc.acpid ]; then
	echo -n "Starting the ACPI... "
	/etc/rc.d/rc.acpid start >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi
fi

# Load a custom screen font and keymap
if [ -x /etc/rc.d/rc.charset ]; then
    echo -n "Loading screen fonts and keymaps... "
    /etc/rc.d/rc.charset >>${log} 2>&1 &&
    echo "ok" || echo "error"
fi

# Start the GPM mouse server:
if [ "${gpm}" = "YES" ]; then
    if [ -x /usr/sbin/gpm ]; then
	echo -n "Starting GPM... "
	/etc/rc.d/rc.gpm start >>${log} 2>&1 &&
	echo "ok" || echo "error"
    fi  
fi

# Start the local setup procedure.
if [ -x /etc/rc.d/rc.local ]; then
    echo -n "Starting the rc.local... "
    /etc/rc.d/rc.local >>${log} 2>&1 &&
    echo "ok" || echo "error"
fi

# All done.
